"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(require("react"));
const Modal_1 = __importDefault(require("@/components/elements/base/modal/Modal"));
const Card_1 = __importDefault(require("@/components/elements/base/card/Card"));
const IconButton_1 = __importDefault(require("@/components/elements/base/button-icon/IconButton"));
const react_2 = require("@iconify/react");
const Button_1 = __importDefault(require("@/components/elements/base/button/Button"));
const Input_1 = __importDefault(require("@/components/elements/form/input/Input"));
const Checkbox_1 = __importDefault(require("@/components/elements/form/checkbox/Checkbox"));
const text_1 = require("../utils/text");
const Listbox_1 = __importDefault(require("@/components/elements/form/listbox/Listbox"));
const options = ["url", "email", "submit"];
const methods = ["GET", "POST"];
const Dialog = ({ open, setOpen, node, actions }) => {
    var _a, _b;
    const props = node.data.props;
    const key = props.propId;
    const [url, setUrl] = (0, react_1.useState)(props.url);
    const [email, setEmail] = (0, react_1.useState)(props.email);
    const [submitUrl, setSubmitUrl] = (0, react_1.useState)(props.submitUrl);
    const [submitMethod, setSubmitMethod] = (0, react_1.useState)((_a = props.submitMethod) !== null && _a !== void 0 ? _a : "GET");
    const [submitAsync, setSubmitAsync] = (0, react_1.useState)(props.submitAsync || false);
    const [newTab, setNewTab] = (0, react_1.useState)(props.newTab || false);
    const [type, setType] = (0, react_1.useState)((_b = props.type) !== null && _b !== void 0 ? _b : "url");
    return (<Modal_1.default open={open} size="md">
      <Card_1.default shape="smooth">
        <div className="flex items-center justify-between p-4 md:p-6">
          <p className="font-sans text-lg font-medium text-muted-900 dark:text-white">
            Update Button
          </p>
          <IconButton_1.default size="sm" shape="full" onClick={() => setOpen(false)}>
            <react_2.Icon icon="lucide:x" className="h-4 w-4"/>
          </IconButton_1.default>
        </div>
        <div className="p-4 md:px-6">
          <div className="mt-4 mb-4">
            <div>
              <div className="flex justify-start items-start gap-5">
                <div className="w-1/3">
                  <Listbox_1.default label="Type" options={options.map((o) => {
            return { value: o, label: (0, text_1.capitalize)(o) };
        })} selected={{
            value: type,
            label: (0, text_1.capitalize)(type),
        }} setSelected={(e) => setType(e.value)}/>
                </div>
                {type === "url" && (<Input_1.default type="text" shape="rounded-sm" label="URL" className="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-full p-2.5 mb-4" placeholder="Eg. https://codecanyon.net/user/mashdiv" defaultValue={url} onChange={(e) => setUrl(e.target.value)}/>)}
                {type === "email" && (<Input_1.default type="text" shape="rounded-sm" label="Email" className="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-full p-2.5" placeholder="Eg. johndoe@example.com" defaultValue={email} onChange={(e) => setEmail(e.target.value)}/>)}
                {type === "submit" && (<div className="flex justify-end items-end gap-5">
                    <Listbox_1.default label="Method" options={methods.map((o) => {
                return { value: o, label: o };
            })} selected={{
                value: submitMethod,
                label: submitMethod,
            }} setSelected={(e) => setSubmitMethod(e.value)}/>
                    <Input_1.default type="text" shape="rounded-sm" label="Submit URL" className="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-full p-2.5" placeholder="Eg. /api/submit" defaultValue={submitUrl} onChange={(e) => setSubmitUrl(e.target.value)}/>
                  </div>)}
              </div>
            </div>
          </div>
        </div>
        <div className="p-4 md:p-6">
          <div className="flex items-center justify-between">
            {type === "url" && (<div className="w-full">
                <Checkbox_1.default label="Open in new tab" checked={newTab} onChange={(e) => setNewTab(e.target.checked)} className="ml-4"/>
              </div>)}
            {type === "submit" && (<div className="w-full">
                <Checkbox_1.default label="Submit Async" checked={submitAsync} onChange={(e) => setSubmitAsync(e.target.checked)} className="ml-4"/>
              </div>)}
            <div className="flex w-full justify-end gap-2">
              <Button_1.default shape="smooth" onClick={() => setOpen(false)}>
                Cancel
              </Button_1.default>
              <Button_1.default variant="solid" color="primary" shape="smooth" onClick={() => {
            actions.setProp(node.id, (prop) => {
                if (!prop[key])
                    prop[key] = {};
                prop[key].type = type.toLowerCase();
                prop[key].url = url;
                prop[key].email = email;
                prop[key].newTab = newTab;
                prop[key].submitUrl = submitUrl;
                prop[key].submitMethod = submitMethod;
                prop[key].submitAsync = submitAsync;
            });
            setOpen(false);
        }}>
                Save
              </Button_1.default>
            </div>
          </div>
        </div>
      </Card_1.default>
    </Modal_1.default>);
};
exports.default = Dialog;
